/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarEditorShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.dialogs.GenerateDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;

public class GenerateActionListener
implements ActionListener {
    private GenerateDialog genDialog;
    private GrammarEditorShellController grammarController;

    public GenerateActionListener(GenerateDialog genDialog, GrammarEditorShellController grammarController) {
        this.genDialog = genDialog;
        this.grammarController = grammarController;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Grammar grammar;
        String currentGraph = this.grammarController.currentNode.toString();
        if (currentGraph.equals("")) {
            currentGraph = this.grammarController.currentNode.getFirstChild().toString();
        }
        this.genDialog.setTitle("Explore graph " + currentGraph + " in grammar " + new File(this.grammarController.getFullName()).getName());
        int matchLimit = -1;
        if (this.genDialog.getCbStopAfter().isSelected() && this.genDialog.getRbSequences().isSelected()) {
            try {
                matchLimit = Integer.parseInt(this.genDialog.getTfSequences().getText());
            }
            catch (NumberFormatException e1) {
                matchLimit = 100;
                this.genDialog.getTfSequences().setText("100");
            }
        }
        Date dt = new Date(Long.MAX_VALUE);
        int delay = -1;
        if (this.genDialog.getCbStopAfter().isSelected() && this.genDialog.getRbSeconds().isSelected()) {
            try {
                delay = Integer.parseInt(this.genDialog.getTfSeconds().getText());
            }
            catch (NumberFormatException e1) {
                delay = 5;
                this.genDialog.getTfSeconds().setText("5");
            }
            dt = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dt);
            calendar.add(13, delay);
            dt = calendar.getTime();
        }
        if (this.genDialog.getCbExploreEmbeddedGraphs().isSelected()) {
            // empty if block
        }
        if ((grammar = this.grammarController.grammar) == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load grammar = gname", "NooJ: Problem with grammar!", 0);
            return;
        }
        String errorMessage = grammar.compileAll(null);
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ: Problem with grammar!", 0);
            return;
        }
        Gram grm = grammar.grams.get(currentGraph);
        if (grm == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find the main graph!", "ONooJ", 0);
            return;
        }
        Language lan = new Language(grammar.iLanguage);
        String[] results = grm.generateParaphrases(1, grammar.grams, matchLimit, dt, grammar.gramType, lan, false);
        if (results == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot generate the language", "ONooJ", 0);
            return;
        }
        DictionaryEditorShell shell = new DictionaryEditorShell();
        shell.getController().initLoad(grammar.iLanguage);
        StringBuilder sb = new StringBuilder();
        int resNb = results.length / 2;
        if (matchLimit != -1 && resNb > matchLimit) {
            resNb = matchLimit;
        }
        for (int i = 0; i < resNb; ++i) {
            int i2 = i * 2;
            int j2 = i2 + 1;
            sb.append(results[i2]);
            if (results[j2] == null || results[j2].equals("")) {
                sb.append(",NOINFO\n");
                continue;
            }
            sb.append(",");
            if (this.isASingleAnnotation(results[j2])) {
                String info = results[j2].substring(1, results[j2].length() - 2);
                sb.append(info);
            } else {
                sb.append(results[j2]);
            }
            sb.append("\n");
        }
        String text = "# NooJ V4\n";
        text = text + "# Dictionary\n";
        text = text + "#\n";
        text = text + "# Input Language is: " + grammar.iLanguage + "\n";
        text = text + "#\n";
        text = text + "# Alphabetical order is not required.\n";
        text = text + "#\n";
        text = text + "# Use inflectional & derivational paradigms' description files (.nof), e.g.:\n";
        text = text + "# Special Command: #use paradigms.nof\n";
        text = text + "#\n";
        text = text + "# Special Features: +NW (non-word) +FXC (frozen expression component) +UNAMB (unambiguous lexical entry)\n";
        text = text + "#                   +FLX= (inflectional paradigm) +DRV= (derivational paradigm)\n";
        text = text + "#\n";
        text = text + "# Special Characters: '\\' '\"' '+' ',' '#' ' '\n";
        text = text + "#\n";
        text = text + "# Dictionary was generated automatically: " + resNb + " entries.\n";
        text = text + "#\n";
        text = text + sb.toString();
        shell.getTextPane().setText(text);
        Launcher.getDesktopPane().add(shell);
        shell.setVisible(true);
    }

    private boolean isASingleAnnotation(String info) {
        if (info == null || "".equals(info)) {
            return false;
        }
        if (info.charAt(0) != '<') {
            return false;
        }
        if (info.charAt(info.length() - 1) != '>') {
            return false;
        }
        info = info.substring(1, info.length() - 2);
        int level = 1;
        for (int i = 0; i < info.length(); ++i) {
            char character = info.charAt(i);
            if (character == '<') {
                ++level;
            } else if (character == '>') {
                --level;
            }
            if (level != 0) continue;
            return false;
        }
        return level == true;
    }
}

